﻿using System.Collections.Generic;

public class GetRequestorSpecialized 
{
    public static string Get(string requestUrl, IDictionary<string, string> headers, string acceptType = WebConstants.JsonMimeType)
    {
        var request = WebRequestorCore.CreateRequest(requestUrl);

        request.KeepAlive = true;
        request.Method = "GET";
        request.Accept = acceptType;

        foreach (var key in headers.Keys)
            request.Headers.Add(key, headers[key]);

        return WebRequestorCore.GetResponse(request, requestUrl);
    }
}

